/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.models.QuadTransformers;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.IUnbakedGeometry;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4730;
import net.minecraft.class_765;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_806;
import slimeknights.mantle.client.model.util.BakedItemModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.ReversedListBuilder;

public class MantleItemLayerModel
implements IUnbakedGeometry<MantleItemLayerModel> {
    public static final Loader LOADER = new Loader();
    private static final class_2350[] HORIZONTALS = new class_2350[]{class_2350.field_11036, class_2350.field_11033};
    private static final class_2350[] VERTICALS = new class_2350[]{class_2350.field_11039, class_2350.field_11034};
    private final List<LayerData> layers;

    private LayerData getLayer(int index) {
        if (index < 0 || index >= this.layers.size()) {
            return LayerData.DEFAULT;
        }
        return this.layers.get(index);
    }

    public class_1087 bake(class_793 owner, class_7775 baker, Function<class_4730, class_1058> spriteGetter, class_3665 modelTransform, class_806 overrides, class_2960 modelLocation, boolean isGui3d) {
        ImmutableList.Builder materialBuilder = ImmutableList.builder();
        int i = 0;
        while (owner.method_3432("layer" + i)) {
            materialBuilder.add((Object)owner.method_24077("layer" + i));
            ++i;
        }
        ImmutableList textures = materialBuilder.build();
        class_1058 particle = spriteGetter.apply(owner.method_3432("particle") ? owner.method_24077("particle") : (class_4730)textures.get(0));
        ReversedListBuilder<Mesh> builder = new ReversedListBuilder<Mesh>();
        ItemLayerPixels pixels = textures.size() == 1 ? null : new ItemLayerPixels();
        class_4590 transform = modelTransform.method_3509();
        for (int i2 = textures.size() - 1; i2 >= 0; --i2) {
            class_1058 sprite = spriteGetter.apply((class_4730)textures.get(i2));
            LayerData data = this.getLayer(i2);
            builder.add(MantleItemLayerModel.getQuadsForSprite(data.color(), data.noTint() ? -1 : i2, sprite, transform, data.luminosity(), pixels));
        }
        MeshBuilder finalMesh = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        QuadEmitter emitter = finalMesh.getEmitter();
        for (Mesh mesh : builder.build()) {
            mesh.outputTo(emitter);
        }
        return new BakedItemModel(finalMesh.build(), quad -> true, particle, owner.method_3443(), overrides, true, owner.method_24298().method_24299());
    }

    public static Mesh getQuadsForSprite(int color, int tint, class_1058 sprite, class_4590 transform, int luminosity) {
        return MantleItemLayerModel.getQuadsForSprite(color, tint, sprite, transform, luminosity, null);
    }

    public static Mesh getQuadsForSprite(int color, int tint, class_1058 sprite, class_4590 transform, int luminosity, @Nullable ItemLayerPixels pixels) {
        int off;
        int off2;
        boolean face;
        boolean canDraw;
        boolean building;
        int u;
        MeshBuilder mesh = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        int uMax = sprite.method_45851().method_45807();
        int vMax = sprite.method_45851().method_45815();
        FaceData faceData = new FaceData(uMax, vMax);
        boolean translucent = false;
        for (int f = 0; f < sprite.method_45851().method_45819(); ++f) {
            boolean[] ptv = new boolean[uMax];
            Arrays.fill(ptv, true);
            for (int v = 0; v < vMax; ++v) {
                int ptu = 1;
                for (u = 0; u < uMax; ++u) {
                    int t;
                    int alpha = sprite.method_45851().getPixelRGBA(f, u, vMax - v - 1) >> 24 & 0xFF;
                    int n = t = (float)alpha / 255.0f <= 0.1f ? 1 : 0;
                    if (t == 0 && alpha < 255) {
                        translucent = true;
                    }
                    if (ptu != 0 && t == 0) {
                        faceData.set(class_2350.field_11039, u, v);
                    }
                    if (ptu == 0 && t != 0) {
                        faceData.set(class_2350.field_11034, u - 1, v);
                    }
                    if (ptv[u] && t == 0) {
                        faceData.set(class_2350.field_11036, u, v);
                    }
                    if (!ptv[u] && t != 0) {
                        faceData.set(class_2350.field_11033, u, v - 1);
                    }
                    ptu = t;
                    ptv[u] = t;
                }
                if (ptu != 0) continue;
                faceData.set(class_2350.field_11034, uMax - 1, v);
            }
            for (int u2 = 0; u2 < uMax; ++u2) {
                if (ptv[u2]) continue;
                faceData.set(class_2350.field_11033, u2, vMax - 1);
            }
        }
        for (class_2350 facing : HORIZONTALS) {
            for (int v = 0; v < vMax; ++v) {
                int uStart = 0;
                int uEnd = uMax;
                building = false;
                for (int u3 = 0; u3 < uMax; ++u3) {
                    canDraw = pixels == null || !pixels.get(u3, v, uMax, vMax);
                    boolean bl = face = canDraw && faceData.get(facing, u3, v);
                    if (face) {
                        uEnd = u3 + 1;
                        if (building) continue;
                        building = true;
                        uStart = u3;
                        continue;
                    }
                    if (!building || canDraw && !translucent) continue;
                    off2 = facing == class_2350.field_11033 ? 1 : 0;
                    MantleItemLayerModel.buildSideQuad(mesh, transform, facing, color, tint, sprite, uStart, v + off2, uEnd - uStart, luminosity);
                    building = false;
                }
                if (!building) continue;
                off = facing == class_2350.field_11033 ? 1 : 0;
                MantleItemLayerModel.buildSideQuad(mesh, transform, facing, color, tint, sprite, uStart, v + off, uEnd - uStart, luminosity);
            }
        }
        for (class_2350 facing : VERTICALS) {
            for (u = 0; u < uMax; ++u) {
                int vStart = 0;
                int vEnd = vMax;
                building = false;
                for (int v = 0; v < vMax; ++v) {
                    canDraw = pixels == null || !pixels.get(u, v, uMax, vMax);
                    boolean bl = face = canDraw && faceData.get(facing, u, v);
                    if (face) {
                        vEnd = v + 1;
                        if (building) continue;
                        building = true;
                        vStart = v;
                        continue;
                    }
                    if (!building || canDraw && !translucent) continue;
                    off2 = facing == class_2350.field_11034 ? 1 : 0;
                    MantleItemLayerModel.buildSideQuad(mesh, transform, facing, color, tint, sprite, u + off2, vStart, vEnd - vStart, luminosity);
                    building = false;
                }
                if (!building) continue;
                off = facing == class_2350.field_11034 ? 1 : 0;
                MantleItemLayerModel.buildSideQuad(mesh, transform, facing, color, tint, sprite, u + off, vStart, vEnd - vStart, luminosity);
            }
        }
        MantleItemLayerModel.buildQuad(mesh, transform, class_2350.field_11043, sprite, color, tint, luminosity, 0.0f, 0.0f, 0.46875f, sprite.method_4594(), sprite.method_4575(), 0.0f, 1.0f, 0.46875f, sprite.method_4594(), sprite.method_4593(), 1.0f, 1.0f, 0.46875f, sprite.method_4577(), sprite.method_4593(), 1.0f, 0.0f, 0.46875f, sprite.method_4577(), sprite.method_4575());
        MantleItemLayerModel.buildQuad(mesh, transform, class_2350.field_11035, sprite, color, tint, luminosity, 0.0f, 0.0f, 0.53125f, sprite.method_4594(), sprite.method_4575(), 1.0f, 0.0f, 0.53125f, sprite.method_4577(), sprite.method_4575(), 1.0f, 1.0f, 0.53125f, sprite.method_4577(), sprite.method_4593(), 0.0f, 1.0f, 0.53125f, sprite.method_4594(), sprite.method_4593());
        if (pixels != null && sprite.method_45851().method_45819() > 0) {
            for (int v = 0; v < vMax; ++v) {
                for (int u4 = 0; u4 < uMax; ++u4) {
                    int alpha = sprite.method_45851().getPixelRGBA(0, u4, vMax - v - 1) >> 24 & 0xFF;
                    if (!((float)alpha / 255.0f > 0.1f)) continue;
                    pixels.set(u4, v, uMax, vMax);
                }
            }
        }
        return mesh.build();
    }

    private static void buildSideQuad(MeshBuilder builder, class_4590 transform, class_2350 side, int color, int tint, class_1058 sprite, int u, int v, int size, int luminosity) {
        float eps = 0.01f;
        int width = sprite.method_45851().method_45807();
        int height = sprite.method_45851().method_45815();
        float x0 = (float)u / (float)width;
        float y0 = (float)v / (float)height;
        float x1 = x0;
        float y1 = y0;
        float z0 = 0.46875f;
        float z1 = 0.53125f;
        switch (side) {
            case field_11039: {
                z0 = 0.53125f;
                z1 = 0.46875f;
            }
            case field_11034: {
                y1 = (float)(v + size) / (float)height;
                break;
            }
            case field_11033: {
                z0 = 0.53125f;
                z1 = 0.46875f;
            }
            case field_11036: {
                x1 = (float)(u + size) / (float)width;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float dx = (float)side.method_10163().method_10263() * 0.01f / (float)width;
        float dy = (float)side.method_10163().method_10264() * 0.01f / (float)height;
        float u0 = 16.0f * (x0 - dx);
        float u1 = 16.0f * (x1 - dx);
        float v0 = 16.0f * (1.0f - y0 - dy);
        float v1 = 16.0f * (1.0f - y1 - dy);
        MantleItemLayerModel.buildQuad(builder, transform, side.method_10166() == class_2350.class_2351.field_11052 ? side.method_10153() : side, sprite, color, tint, luminosity, x0, y0, z0, sprite.method_4580((double)u0), sprite.method_4570((double)v0), x1, y1, z0, sprite.method_4580((double)u1), sprite.method_4570((double)v1), x1, y1, z1, sprite.method_4580((double)u1), sprite.method_4570((double)v1), x0, y0, z1, sprite.method_4580((double)u0), sprite.method_4570((double)v0));
    }

    protected static void buildQuad(MeshBuilder builder, class_4590 transform, class_2350 side, class_1058 sprite, int color, int tint, int luminosity, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        QuadEmitter emitter = builder.getEmitter();
        MaterialFinder material = RendererAccess.INSTANCE.getRenderer().materialFinder();
        emitter.spriteBake(sprite, 0);
        emitter.colorIndex(tint);
        emitter.nominalFace(side);
        emitter.material(material.disableDiffuse(true).find());
        MantleItemLayerModel.putVertex(emitter, side, x0, y0, z0, u0, v0, color, luminosity, 0);
        MantleItemLayerModel.putVertex(emitter, side, x1, y1, z1, u1, v1, color, luminosity, 1);
        MantleItemLayerModel.putVertex(emitter, side, x2, y2, z2, u2, v2, color, luminosity, 2);
        MantleItemLayerModel.putVertex(emitter, side, x3, y3, z3, u3, v3, color, luminosity, 3);
        QuadTransformers.applying((class_4590)transform).transform((MutableQuadView)emitter);
        emitter.emit();
    }

    private static void putVertex(QuadEmitter consumer, class_2350 side, float x, float y, float z, float u, float v, int color, int luminosity, int vertexIndex) {
        consumer.pos(vertexIndex, x, y, z);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        consumer.spriteColor(vertexIndex, 0, MantleItemLayerModel.encodeQuadColor(r, g, b, a));
        consumer.sprite(vertexIndex, 0, u, v);
        consumer.lightmap(vertexIndex, class_765.method_23687((int)luminosity, (int)luminosity));
        float offX = side.method_10148();
        float offY = side.method_10164();
        float offZ = side.method_10165();
        consumer.normal(vertexIndex, offX, offY, offZ);
    }

    private static int encodeQuadColor(float x, float y, float z, float w) {
        int r = (int)(x * 255.0f);
        int g = (int)(y * 255.0f);
        int b = (int)(z * 255.0f);
        int a = (int)(w * 255.0f);
        return (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
    }

    public MantleItemLayerModel(List<LayerData> layers) {
        this.layers = layers;
    }

    private record LayerData(int color, int luminosity, boolean noTint) {
        private static final LayerData DEFAULT = new LayerData(-1, 0, false);

        public static LayerData fromJson(JsonObject json) {
            int color = JsonHelper.parseColor(class_3518.method_15253((JsonObject)json, (String)"color", (String)""));
            int luminosity = class_3518.method_15260((JsonObject)json, (String)"luminosity");
            boolean noTint = class_3518.method_15258((JsonObject)json, (String)"no_tint", (boolean)false);
            return new LayerData(color, luminosity, noTint);
        }
    }

    private static class FaceData {
        private final EnumMap<class_2350, BitSet> data = new EnumMap(class_2350.class);
        private final int vMax;

        FaceData(int uMax, int vMax) {
            this.vMax = vMax;
            this.data.put(class_2350.field_11039, new BitSet(uMax * vMax));
            this.data.put(class_2350.field_11034, new BitSet(uMax * vMax));
            this.data.put(class_2350.field_11036, new BitSet(uMax * vMax));
            this.data.put(class_2350.field_11033, new BitSet(uMax * vMax));
        }

        public void set(class_2350 facing, int u, int v) {
            this.data.get(facing).set(this.getIndex(u, v));
        }

        public boolean get(class_2350 facing, int u, int v) {
            return this.data.get(facing).get(this.getIndex(u, v));
        }

        private int getIndex(int u, int v) {
            return v * this.vMax + u;
        }
    }

    private static class Loader
    implements IGeometryLoader<MantleItemLayerModel> {
        private Loader() {
        }

        public MantleItemLayerModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            List<LayerData> layers = JsonHelper.parseList(modelContents, "layers", LayerData::fromJson);
            return new MantleItemLayerModel(layers);
        }
    }
}

